/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.widget;

import icyllis.modernui.animation.Interpolator;
import icyllis.modernui.view.UIManager;
import javax.annotation.Nonnull;
import net.minecraft.util.math.MathHelper;

public class ScrollController {
    private float startValue;
    private float targetValue;
    private float maxValue;
    private float currValue;
    private long startTime;
    private int duration;
    @Nonnull
    private final IListener listener;

    public ScrollController(@Nonnull IListener listener) {
        this.listener = listener;
    }

    public void update(long time) {
        if (this.currValue != this.targetValue) {
            float p = Math.min((float)(time - this.startTime) / (float)this.duration, 1.0f);
            p = Interpolator.SINE.getInterpolation(p);
            this.currValue = MathHelper.func_219799_g((float)p, (float)this.startValue, (float)this.targetValue);
            this.listener.onScrollAmountUpdated(this, this.currValue);
            UIManager.getInstance().repostCursorEvent();
        }
    }

    public void setMaxScroll(float max) {
        this.maxValue = max;
    }

    public void setStartValue(float start) {
        this.startValue = start;
    }

    public float getCurrValue() {
        return this.currValue;
    }

    public int getDuration() {
        return this.duration;
    }

    public void scrollBy(float delta, int duration) {
        this.scrollTo(this.targetValue + delta, duration);
    }

    public boolean scrollBy(float delta) {
        return this.scrollTo(this.targetValue + delta);
    }

    public void scrollTo(float target, int duration) {
        this.startTime = UIManager.getInstance().getDrawingTime();
        this.startValue = this.currValue;
        float scale = (float)UIManager.getInstance().getGuiScale();
        float endX = MathHelper.func_76131_a((float)target, (float)0.0f, (float)this.maxValue) * scale;
        this.targetValue = (float)((int)endX) / scale;
        this.duration = duration;
    }

    public boolean scrollTo(float target) {
        float lastTime = this.startTime;
        this.startTime = UIManager.getInstance().getDrawingTime();
        this.startValue = this.currValue;
        float scale = (float)UIManager.getInstance().getGuiScale();
        float end = MathHelper.func_76131_a((float)target, (float)0.0f, (float)this.maxValue) * scale;
        this.targetValue = (float)((int)end) / scale;
        if (this.startValue == this.targetValue) {
            return false;
        }
        float dis = Math.abs(this.targetValue - this.currValue);
        this.duration = (double)dis > 60.0 ? (int)(Math.sqrt((double)dis / 60.0) * 200.0) : 200;
        dis = (float)this.startTime - lastTime;
        if ((double)dis < 120.0) {
            this.duration = (int)((float)this.duration * (dis / 300.0f + 0.6f));
        }
        return true;
    }

    public void abortAnimation() {
        this.currValue = this.targetValue;
        this.listener.onScrollAmountUpdated(this, this.currValue);
        UIManager.getInstance().repostCursorEvent();
    }

    public boolean isScrolling() {
        return this.currValue != this.targetValue;
    }

    @FunctionalInterface
    public static interface IListener {
        public void onScrollAmountUpdated(ScrollController var1, float var2);
    }
}

